from libdebug import debugger
from string import ascii_letters, digits


d = debugger("main", escape_antidebug=True)

def callback(_, __):
    pass

def on_enter_nanosleep(t, _):
    t.syscall_arg0 = 0
    t.syscall_arg1 = 0
    t.syscall_arg2 = 0
    t.syscall_arg3 = 0
    
alphabet = ascii_letters + digits + "_{}"

flag = b""
best_hit_count = 0

while True:
    for c in alphabet:
        r = d.run()
        bp = d.breakpoint(0x13e1, hardware=True, callback=callback, file="binary")
        d.handle_syscall("clock_nanosleep", on_enter=on_enter_nanosleep)
        d.cont()

        r.sendline(flag + c.encode())

        d.wait()

        response = r.recvline()
        
        d.kill()

        if b"Yeah" in response:
            flag += c.encode()
            print(flag)
            break

        if bp.hit_count > best_hit_count:
            best_hit_count = bp.hit_count
            flag += c.encode()
            print(flag)
            break

    if c == "}":
        break

print(flag)